/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.launcher;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.UUID;
import net.runelite.launcher.OS;

public class UniqueID {
    private static final String uuid;

    private static String generateUUID() throws Exception {
        int i;
        StringBuilder systemInfo = new StringBuilder();
        systemInfo.append(System.getProperty("user.home"));
        systemInfo.append(System.getProperty("user.name"));
        systemInfo.append(System.getProperty("user.country"));
        systemInfo.append(System.getProperty("os.arch"));
        systemInfo.append(OS.getOs().name());
        systemInfo.append(Runtime.getRuntime().availableProcessors());
        systemInfo.append(UniqueID.fetchSerialNumber(OS.getOs()));
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] hashBytes = md.digest(systemInfo.toString().getBytes(StandardCharsets.UTF_8));
        hashBytes[6] = (byte)(hashBytes[6] & 0xF);
        hashBytes[6] = (byte)(hashBytes[6] | 0x40);
        hashBytes[8] = (byte)(hashBytes[8] & 0x3F);
        hashBytes[8] = (byte)(hashBytes[8] | 0x80);
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(hashBytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(hashBytes[i] & 0xFF);
        }
        return new UUID(msb, lsb).toString();
    }

    private static String fetchSerialNumber(OS.OSType type) {
        if (type == OS.OSType.Windows) {
            try {
                return UniqueID.fetchSerialNumberWindows();
            }
            catch (Exception exception) {
            }
        } else if (type == OS.OSType.MacOS) {
            try {
                return UniqueID.fetchSerialNumberMacOS();
            }
            catch (Exception exception) {
            }
        } else if (type == OS.OSType.Linux) {
            try {
                return UniqueID.fetchSerialNumberLinux();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "UNKNOWN-UUID";
    }

    static String fetchSerialNumberWindows() throws Exception {
        String line;
        Process process = Runtime.getRuntime().exec("wmic csproduct get uuid");
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String uuid = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() <= 0 || line.contains("UUID")) continue;
            uuid = line;
            break;
        }
        assert (uuid != null);
        return uuid.trim();
    }

    static String fetchSerialNumberMacOS() throws Exception {
        String[] cmd = new String[]{"/bin/sh", "-c", "ioreg -rd1 -c IOPlatformExpertDevice | grep -E \"IOPlatformUUID\" | awk '{print $3}' | sed -e 's/\"//g'"};
        Process process = Runtime.getRuntime().exec(cmd);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        return reader.readLine().trim();
    }

    static String fetchSerialNumberLinux() throws Exception {
        String[] cmd = new String[]{"/bin/sh", "-c", "cat /etc/machine-id"};
        Process process = Runtime.getRuntime().exec(cmd);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        return reader.readLine().trim();
    }

    public static String getUuid() {
        return uuid;
    }

    static {
        try {
            uuid = UniqueID.generateUUID();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

