/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.launcher;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LauncherProperties {
    private static final Logger log = LoggerFactory.getLogger(LauncherProperties.class);
    private static final String AUTH_INITIAL = "skenglite.auth.initial";
    private static final String LAUNCHER_VERSION = "runelite.launcher.version";
    private static final String DISCORD_INVITE = "runelite.discord.invite";
    private static final String TROUBLESHOOTING_LINK = "runelite.wiki.troubleshooting.link";
    private static final String DNS_CHANGE_LINK = "runelite.dnschange.link";
    private static final String DOWNLOAD_LINK = "runelite.download.link";
    private static final String BOOTSTRAP = "runelite.bootstrap";
    private static final String BOOTSTRAPSIG = "runelite.bootstrapsig";
    private static final String SKENGLITE_BOOTSTRAP = "skenglite.bootstrap";
    private static final String SKENGLITE_BOOTSTRAPSIG = "skenglite.bootstrapsig";
    private static final String SKENGLITE_SESSION_INITIAL = "skenglite.session.initial";
    private static final String SKENGLITE_BUILD_ENDPOINT = "skenglite.build.endpoint";
    private static final String SKENGLITE_LAUNCHER_VERSION = "skenglite.launcher.version";
    private static final String SKENGLITE_HWID_ENDPOINT = "skenglite.launcher.hwid";
    private static final String JAGSHARE_SHARE = "skenglite.jagshare.share";
    private static final String JAGSHARE_USE = "skenglite.jagshare.use";
    private static final String MAIN = "runelite.main";
    private static final Properties properties = new Properties();

    public static String getAuthInitial() {
        return properties.getProperty(AUTH_INITIAL);
    }

    public static String getSessionInitial() {
        return properties.getProperty(SKENGLITE_SESSION_INITIAL);
    }

    public static String getBuildEndpoint() {
        return properties.getProperty(SKENGLITE_BUILD_ENDPOINT);
    }

    public static String getVersionKey() {
        return LAUNCHER_VERSION;
    }

    public static String getVersion() {
        return properties.getProperty(LAUNCHER_VERSION);
    }

    public static String getDiscordInvite() {
        return properties.getProperty(DISCORD_INVITE);
    }

    public static String getTroubleshootingLink() {
        return properties.getProperty(TROUBLESHOOTING_LINK);
    }

    public static String getDNSChangeLink() {
        return properties.getProperty(DNS_CHANGE_LINK);
    }

    public static String getDownloadLink() {
        return properties.getProperty(DOWNLOAD_LINK);
    }

    public static String getBootstrap() {
        return properties.getProperty(BOOTSTRAP);
    }

    public static String getBootstrapSig() {
        return properties.getProperty(BOOTSTRAPSIG);
    }

    public static String getSkengLiteBootstrap() {
        return properties.getProperty(SKENGLITE_BOOTSTRAP);
    }

    public static String getSkengLiteBootstrapSig() {
        return properties.getProperty(SKENGLITE_BOOTSTRAPSIG);
    }

    public static String getSkengLiteLauncherVersion() {
        return properties.getProperty(SKENGLITE_LAUNCHER_VERSION);
    }

    public static String getJagshareUseEndpoint() {
        return properties.getProperty(JAGSHARE_USE);
    }

    public static String getJagshareShareEndpoint() {
        return properties.getProperty(JAGSHARE_SHARE);
    }

    public static String getHWIDEndpoint() {
        return properties.getProperty(SKENGLITE_HWID_ENDPOINT);
    }

    public static String getMain() {
        return properties.getProperty(MAIN);
    }

    static {
        InputStream in = LauncherProperties.class.getResourceAsStream("launcher.properties");
        try {
            properties.load(in);
        }
        catch (IOException ex) {
            log.warn("Unable to load properties", ex);
        }
    }
}

