/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.launcher;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import net.runelite.launcher.BootstrapType;
import net.runelite.launcher.LaunchResult;
import net.runelite.launcher.LauncherProperties;
import net.runelite.launcher.SplashScreen;
import net.runelite.launcher.beans.BuildInfo;
import net.runelite.launcher.beans.JagShareSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapSelectionScreen
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(BootstrapSelectionScreen.class);
    private LaunchResult launchResult;
    private JagShareSession shareSession;
    private static BootstrapSelectionScreen INSTANCE;
    private JComboBox<String> comboBox;
    private JCheckBox rememberCheckBox;
    private Runnable callback;
    private Preferences preferences;
    private final HttpClient httpClient = HttpClient.newBuilder().build();
    private final Gson gson = new Gson();

    private BootstrapSelectionScreen(BuildInfo buildInfo) throws IOException {
        BufferedImage logo;
        this.preferences = Preferences.userRoot().node("skenglite-launcher");
        try (InputStream in = SplashScreen.class.getResourceAsStream("runelite_transparent.png");){
            logo = ImageIO.read(in);
        }
        this.setTitle("SkengLite Launcher");
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setIconImage(logo);
        this.setLayout(null);
        this.setSize(350, 195);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(10, 10));
        mainPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 1));
        JLabel titleLabel = new JLabel("Select RuneLite Version", 0);
        titleLabel.setFont(new Font("Arial", 1, 16));
        titleLabel.setAlignmentX(0.5f);
        String launcherVersion = buildInfo.getLauncherVersion();
        String skengLiteVersion = LauncherProperties.getSkengLiteLauncherVersion();
        if (!skengLiteVersion.equals(launcherVersion)) {
            JLabel versionMismatchLabel = new JLabel("Launcher is outdated", 0);
            versionMismatchLabel.setForeground(Color.RED);
            versionMismatchLabel.setFont(new Font("Arial", 1, 12));
            versionMismatchLabel.setAlignmentX(0.5f);
            titlePanel.add(titleLabel);
            titlePanel.add(Box.createRigidArea(new Dimension(0, 5)));
            titlePanel.add(versionMismatchLabel);
        } else {
            titlePanel.add(titleLabel);
            this.setSize(350, 175);
        }
        String[] liteOptions = new String[]{"SkengLite - v" + buildInfo.getPatch() + " (" + buildInfo.getId().split("-")[0] + ")", "RuneLite"};
        this.comboBox = new JComboBox<String>(liteOptions);
        this.rememberCheckBox = new JCheckBox("Remember Selection");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridLayout(1, 1, 2, 2));
        JButton startButton = new JButton("Start " + this.comboBox.getSelectedItem().toString().split(" ")[0]);
        final JButton shareButton = new JButton("Jagex Account Sharing");
        this.comboBox.addItemListener(e -> startButton.setText("Start " + this.comboBox.getSelectedItem().toString().split(" ")[0]));
        String launcherAccount = System.getenv("JX_DISPLAY_NAME");
        final JPopupMenu jagShareMenu = new JPopupMenu();
        JMenuItem joinItem = new JMenuItem("Use Share Code");
        JMenuItem shareItem = new JMenuItem("Generate Share Code (" + launcherAccount + ")");
        jagShareMenu.add(joinItem);
        if (launcherAccount != null) {
            jagShareMenu.add(shareItem);
        }
        shareButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    jagShareMenu.show(e.getComponent(), e.getX(), e.getY());
                } else {
                    jagShareMenu.show(shareButton, e.getX(), e.getY());
                }
            }
        });
        joinItem.addActionListener(e -> this.useShareCode());
        shareItem.addActionListener(e -> this.generateShareCode());
        buttonsPanel.add(startButton);
        buttonsPanel.add(shareButton);
        this.loadPreferences();
        JPanel selectionPanel = new JPanel();
        selectionPanel.setLayout(new GridLayout(2, 1, 2, 2));
        selectionPanel.add(this.comboBox);
        selectionPanel.add(this.rememberCheckBox);
        mainPanel.add((Component)titlePanel, "North");
        mainPanel.add((Component)selectionPanel, "Center");
        mainPanel.add((Component)buttonsPanel, "South");
        this.setContentPane(mainPanel);
        startButton.addActionListener(e -> {
            this.savePreferences();
            this.startSelectedOption();
        });
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void generateShareCode() {
        try {
            HashMap<String, String> jagexAccountData = new HashMap<String, String>();
            jagexAccountData.put("JX_REFRESH_TOKEN", System.getenv("JX_REFRESH_TOKEN"));
            jagexAccountData.put("JX_CHARACTER_ID", System.getenv("JX_CHARACTER_ID"));
            jagexAccountData.put("JX_SESSION_ID", System.getenv("JX_SESSION_ID"));
            jagexAccountData.put("JX_DISPLAY_NAME", System.getenv("JX_DISPLAY_NAME"));
            jagexAccountData.put("JX_ACCESS_TOKEN", System.getenv("JX_ACCESS_TOKEN"));
            String jsonPayload = this.gson.toJson(jagexAccountData);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(LauncherProperties.getJagshareShareEndpoint())).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            Type responseType = new TypeToken<Map<String, Object>>(){}.getType();
            Map jsonResponse = (Map)this.gson.fromJson(response.body(), responseType);
            if (((Boolean)jsonResponse.get("success")).booleanValue()) {
                String shareCode = (String)jsonResponse.get("code");
                JTextArea codeArea = new JTextArea(shareCode);
                codeArea.setEditable(false);
                codeArea.setLineWrap(true);
                codeArea.setWrapStyleWord(true);
                JScrollPane scrollPane = new JScrollPane(codeArea);
                scrollPane.setPreferredSize(new Dimension(300, 80));
                JButton copyButton = new JButton("Copy to Clipboard");
                copyButton.addActionListener(event -> {
                    codeArea.selectAll();
                    codeArea.copy();
                    JOptionPane.showMessageDialog(this, "Code copied to clipboard!");
                });
                JPanel panel = new JPanel(new BorderLayout(5, 5));
                panel.add((Component)new JLabel("Share this code with the recipient:"), "North");
                panel.add((Component)scrollPane, "Center");
                panel.add((Component)copyButton, "South");
                JDialog dialog = new JDialog(this, "Share Code Generated", true);
                dialog.setLayout(new BorderLayout());
                dialog.add((Component)panel, "Center");
                dialog.pack();
                dialog.setLocationRelativeTo(this);
                dialog.setResizable(false);
                dialog.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this, "Error generating share code: " + jsonResponse.get("message"), "Error", 0);
            }
        }
        catch (Exception e) {
            log.error("Error generating share code", e);
            JOptionPane.showMessageDialog(this, "Error generating share code: " + e.getMessage(), "Error", 0);
        }
    }

    private void useShareCode() {
        String code = JOptionPane.showInputDialog(this, "Enter the share code you received:", "Use Share Code", 3);
        if (code == null || code.trim().isEmpty()) {
            return;
        }
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(LauncherProperties.getJagshareUseEndpoint() + code.trim())).GET().build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            Type responseType = new TypeToken<Map<String, Object>>(){}.getType();
            Map jsonResponse = (Map)this.gson.fromJson(response.body(), responseType);
            if (((Boolean)jsonResponse.get("success")).booleanValue()) {
                Map data = (Map)jsonResponse.get("data");
                this.shareSession = new JagShareSession((String)data.get("JX_REFRESH_TOKEN"), (String)data.get("JX_CHARACTER_ID"), (String)data.get("JX_SESSION_ID"), (String)data.get("JX_DISPLAY_NAME"), (String)data.get("JX_ACCESS_TOKEN"));
                JOptionPane.showMessageDialog(this, "Successfully retrieved account sharing data for: " + this.shareSession.getDisplayName(), "Success", 1);
                this.launchResult = new LaunchResult(BootstrapType.valueOf(this.comboBox.getSelectedItem().toString().split(" ")[0].toUpperCase()), this.shareSession);
                if (this.callback != null) {
                    this.callback.run();
                }
            } else {
                JOptionPane.showMessageDialog(this, "Error retrieving share data: " + jsonResponse.get("message"), "Error", 0);
            }
        }
        catch (Exception e) {
            log.error("Error using share code", e);
            JOptionPane.showMessageDialog(this, "Error using share code: " + e.getMessage(), "Error", 0);
        }
    }

    private void startSelectedOption() {
        this.launchResult = new LaunchResult(BootstrapType.valueOf(this.comboBox.getSelectedItem().toString().split(" ")[0].toUpperCase()), this.shareSession);
        if (this.callback != null) {
            this.callback.run();
        }
    }

    private void loadPreferences() {
        int savedSelection = this.preferences.getInt("selectedLite", 0);
        boolean remember = this.preferences.getBoolean("remember", false);
        if (remember) {
            this.comboBox.setSelectedItem(this.comboBox.getItemAt(savedSelection));
        }
        this.rememberCheckBox.setSelected(remember);
    }

    private void savePreferences() {
        if (this.rememberCheckBox.isSelected()) {
            this.preferences.putInt("selectedLite", this.comboBox.getSelectedIndex());
        }
        this.preferences.putBoolean("remember", this.rememberCheckBox.isSelected());
    }

    public static LaunchResult getLaunchResult() {
        return BootstrapSelectionScreen.INSTANCE.launchResult;
    }

    public static void init(Runnable callback, BuildInfo buildInfo) {
        try {
            SwingUtilities.invokeAndWait(() -> {
                if (INSTANCE != null) {
                    return;
                }
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    INSTANCE = new BootstrapSelectionScreen(buildInfo);
                    BootstrapSelectionScreen.INSTANCE.callback = callback;
                }
                catch (Exception e) {
                    log.warn("Unable to start splash screen", e);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException bs) {
            throw new RuntimeException(bs);
        }
    }

    public static void stop() {
        SwingUtilities.invokeLater(() -> {
            if (INSTANCE == null) {
                return;
            }
            INSTANCE.setDefaultCloseOperation(0);
            INSTANCE.dispose();
            INSTANCE = null;
        });
    }
}

